-- V7.71 The temperature/naughtiness meters will now show in the caves
-- V7.7 Fix for the new moisture meter (WX78 only)-- V7.6 Fixed the disappearing crafting tab when using a pad.
-- V7.5 The mod is compatible with Backpack and/or Amulet Slot(s) again.
-- V7.4 The mod is compatible with RPG HUD again.
-- V7.3 The mod is compatible with Display Food Values again.
-- V7.2 Fixed the status display disappearing values bug.
-- V7.1 All's Well That Maxwell update
-- v7.0 Six Feet Under update
-- v6.1 Bugfix on the naughtiness meter
-- V6.0 A Moderately Friendly Update
-- V5.0 The Stuff of Nightmares update
-- V4.4 Bugfix - WX78 upgrades will show correctly
-- V4.3 Hungry for your hunger update
-- V4.2 No more incompatibilities with Display Food Values
-- V4.1 Bugfix for crashing when eating gears with WX78
-- V4.0 Strange new powers update
-- V3.1 Added temperature tab
-- V3.0 It's not a rock update - added naughtiness tab
-- V2.0 Underground update - downscaled the icons' size by 10% and rearranged their position
-- V1.1 Added custom background
-- V1.0 Release version

-- Created by Kiopho
--------------------------------------------------------------------------------------------

Assets = {
	Asset("ATLAS", "images/status_bg.xml"),
}

--------------------------------------------------------------------------------------------

local Badge = GLOBAL.require "widgets/badge"
local kramped = GLOBAL.require "components/kramped"

local NaughtyBadge = Class(Badge, function(status, owner)
    Badge._ctor(status, "naughty", owner)
end)

local TemperatureBadge = Class(Badge, function(status, owner)
    Badge._ctor(status, "temperature", owner)
end)

local function StatusPost()

	local player = GLOBAL.GetPlayer()
	local controls = player.HUD.controls
	local status = controls.status

	controls.clock.text:SetPosition(5,0,0)
	
	controls.sidepanel:SetPosition(-100,-70,0)

	status.brain:SetPosition(0,10,0)
	status.stomach:SetPosition(-62,35,0)
	status.heart:SetPosition(62,35,0)
	
	status.naughty = status:AddChild(NaughtyBadge(owner))
	status.naughty:SetPosition(-57.5,5,0)
	status.naughty:SetNaughty(status.owner.components.kramped:GetNaughtyness(), status.owner.components.kramped:GetLimit())

	status.temperature = status:AddChild(TemperatureBadge(owner))
	status.temperature:SetPosition(57.5,5,0)
	status.temperature:SetTemperature(status.owner.components.temperature:GetCurrent())
	
	status.inst:ListenForEvent("naughtydelta", function(inst) status.naughty:SetNaughty(player.components.kramped.GetNaughtyness(), player.components.kramped.GetLimit()) end, status.owner)
	status.inst:ListenForEvent("temperaturedelta", function(inst, data) status.temperature:SetTemperature(status.owner.components.temperature:GetCurrent()) end, status.owner)
	
	if status.moisturemeter then
		status.moisturemeter:SetPosition(0,-80,0)
	end
	
--	controls.status.temperature:Kill()
--	controls.status.naughty:Kill()
end

AddSimPostInit(StatusPost)

local function applyupgrades(inst)

	local max_upgrades = 15
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil(TUNING.WX78_MIN_HUNGER + upgrades* (TUNING.WX78_MAX_HUNGER - TUNING.WX78_MIN_HUNGER)/max_upgrades)
	inst.components.health.maxhealth = math.ceil(TUNING.WX78_MIN_HEALTH + upgrades* (TUNING.WX78_MAX_HEALTH - TUNING.WX78_MIN_HEALTH)/max_upgrades)
	inst.components.sanity.max = math.ceil(TUNING.WX78_MIN_SANITY + upgrades* (TUNING.WX78_MAX_SANITY - TUNING.WX78_MIN_SANITY)/max_upgrades)

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
	
end

-- WX78 upgrade animation
local function newoneat(inst, food)
	
	if food and food.components.edible and food.components.edible.foodtype == "GEARS" then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.2,.9,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.2,.9,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.2,.9,.7)
	end
end

local function wx78eat(inst)
	inst.components.eater:SetOnEatFn(newoneat)
end

AddPrefabPostInit("wx78", wx78eat)